#include "API.h"

#include "CPhone.h"
#include "CRegex.h"
#include "CQCMn.h"
#include "CQCUs.h"
#include "CCase.h"
#include "CDocDct.h"
#include "CSkpDct.h"
#include "CSugDct.h"


#define DICTMAGIC 31415926L

typedef struct DictList {
	CDict	*Dictionary;
	unsigned long	DictNum;
	short		DictType;
	DictList *next;
} DictList;

class SpellClass : public CPhoneme, public CRegex, public CCase
{
public:
	SpellClass();
	~SpellClass();
	
	long	NumDictionaries;
	long	magic;
	
	CDocDict *theDocDict;
	unsigned long	theDocNum;
	
	DictList  		*Dictionaries;
	UBloom	 		*DupDict;
	
	short				DictTypeFound;
	unsigned long	DictsSearched;
	unsigned long	DictSearching;
	short				Phonetic;
	
	char	LastWord[MAXWORDLENGTH+1];
	
	CDict 	*FindDict(unsigned long *DictNum, short *DictType);
	void 		AddDict(unsigned long *DictNum, short DictType, long NumBuffers, FioParam * theFile);
	void		DeleteDict(unsigned long DicNum);
	short		CheckDup(char *Word);
	void  	ClearDup();
	
	
}; // SpellClass


